<?php

namespace Fir\Models;

class Candidate extends Model {

    /**
     * @var string
     */
    public $username;

    /**
     * @var string
     */
    public $password;

    /**
     * @var string
     */
    public $rememberToken;
		

    
    public function add($userid, $name, $email, $password, $tag_line, $category_id, $filename) {
		
	    $Insert = $this->db->insert('user', array(
	   'userid' => $userid,
	   'password' => $password,
	   'name' => $name,
	   'email' => $email,
	   'tag_line' => $tag_line,
	   'category_id' => $category_id,
	   'imagelocation' => $filename,
	   'joined' => date('Y-m-d H:i:s'),
	   'user_type' => 2
		));	
		  
		return $Insert->rowCount();  
    }
    public function list()
    {
		
        $candidates = $this->db->select('user', '*', ["user_type" => 2]);

        return $candidates;
    }
    public function approve()
    {
            $query = $this->db->select("user", '*', [
                "OR" => [
                    "AND #first" => [
                        "user_type" => "2",
                        "approved" => "0"
                    ],
                    "AND #second" => [
                        "user_type" => "2",
                        "approved" => "2"
                    ]
                ],
                "ORDER" =>["joined" => "DESC"]
            ]);
        
        //$query = $this->db->select('user', '*', ["OR" =>["approved" => 0, "approved" => 2], "ORDER" =>["joined" => "DESC"]]);

        return $query;
    }    
    public function approved()
    {
        $query = $this->db->select('user', '*', ["AND" => ["approved" => 1, "user_type" => 2], "ORDER" =>["joined" => "DESC"]]);

        return $query;
    }  
    public function has($id) {

		$has = $this->db->has("user", ["userid" => $id]);		
		  
		return $has;  
    }
    public function get($id) {

		$query = $this->db->select("user", "*", ["userid" => $id]);	
        foreach($query as $row){}		
		  
		return $row;  
    }
    public function getId($id) {

		$query = $this->db->select("user", "*", ["id" => $id]);	
        foreach($query as $row){}		
		  
		return $row;  
    }
    public function update($name, $email, $tag_line, $category_id, $background, $education, $career, $userid) {

		$Update = $this->db->update('user',[
           'name' => $name,
           'email' => $email,
           'tag_line' => $tag_line,
           'category_id' => $category_id,
           'background' => $background,
           'education' => $education,
           'career' => $career,
		],[
		    'userid' => $userid
		  ]);
		  
		return $Update->rowCount();  
    }
    public function changeImage($filename, $userid) {

		$Update = $this->db->update('user',[
	       'imagelocation' => $filename,
		],[
		    'userid' => $userid
		  ]);
		  
		return $Update->rowCount();  
    }
    
    public function hasEmail($email) {

		$has = $this->db->has("user", ["email" => $email]);		
		  
		return $has;  
    }
    
    public function register($userid, $name, $email, $password, $category_id) {
        
        $filename = 'default.png';
		
	    $Insert = $this->db->insert('user', array(
	   'userid' => $userid,
	   'password' => $password,
	   'name' => $name,
	   'email' => $email,
	   'category_id' => $category_id,
	   'imagelocation' => $filename,
	   'joined' => date('Y-m-d H:i:s'),
	   'user_type' => 2
		));	
		  
		return $Insert->rowCount();  
    }    
    public function getCandidates($id) {

		$query = $this->db->select("user", "*", ["category_id" => $id]);	
		  
		return $query;  
    }
    public function getApproved($id) {

		$query = $this->db->select("user", "*", ["approved" => 1, "category_id" => $id]);	
		  
		return $query;  
    }
    
    public function has_candidates($id) {

		$has = $this->db->has("user", "*", ["category_id" => $id]);		
		  
		return $has;  
    }
    public function vote($category, $candidate, $voter) {
		
	    $Insert = $this->db->insert('votes', array(
	   'userid' => $voter,
	   'candidate' => $candidate,
	   'category_id' => $category,
		));	
		  
		return $Insert->rowCount();  
    }  
    public function count() {
		
       $candidates = $this->db->select('user', '*', ["AND" =>["user_type" => 2], "ORDER" => ["joined" => "DESC"]]);
       foreach ($candidates as $row) {

         $g = $this->db->count('votes', ["candidate" => $row["id"]]);
          
          $count[] = [
               "candidate_id" => $row["id"],
               "g" => $g,
          ];

       }
		  
		return $count;  
    }    
	
}